@echo off
setlocal
setlocal enableextensions
setlocal enabledelayedexpansion


   rem Checks if user is using full administrator priviliges and exits if not
   rem

   whoami /groups | find "S-1-16-12288" > nul
   if %errorlevel% GTR 0 (
     echo.
     echo MUST be run as Administrator
     echo.
     pause
     goto:EOF
   )
 
   rem Changes back to current drive and directory
   rem

   cd /d "%~dp0"


   rem Asks user for input file
   rem

   cls
   echo.
   dir /b *.txt | findstr /i /e /n ".txt" 
   echo.
   set /P vpn_setup_inputFileNumber=Enter the number of your configuration file (see above) or 0 (zero) to abort:
   if %vpn_setup_inputFileNumber%==0 goto:EOF
   set vpn_setup_inputFile="%~n0.txt"
   if "%vpn_setup_inputFileNumber%"=="" goto proceed
   dir /b *.txt | findstr /i /e /n ".txt" | findstr /i /b "%vpn_setup_inputFileNumber%:" > "%TEMP%\%~n0.tmp"
   for /f "usebackq tokens=2 delims=:" %%i in ("%TEMP%\%~n0.tmp") do set vpn_setup_inputFile="%%i"
   if exist "%TEMP%\%~n0.tmp" del "%TEMP%\%~n0.tmp"


:proceed


   rem Retrieves parameters from configuration file and sets variables
   rem

   echo.
   echo Reading configuration from %vpn_setup_inputFile%
   echo.   
   for /f "eol=; usebackq tokens=* delims=" %%i in (%vpn_setup_inputFile%) do call set %%i


   rem Imports certificate
   rem

   echo Importing certificate from %vpn_setup_certificateFile%
   echo Enter password for %vpn_setup_certificateFile%
   certutil.exe -f -importpfx %vpn_setup_certificateFile% > "%TEMP%\%~n0.tmp"

   rem Retrieves Certificate Authority coordinates from certutil --importpfx output 
   rem

   for /f "usebackq tokens=*" %%i in (`findstr "\".*\"" "%TEMP%\%~n0.tmp"`) do (
      set v=%%i
      call set v=%%v:"=%%
      for /f  "tokens=2 delims=" %%A in ('call echo.%%v%%') do (
         set v=%%A
      )
   )

:loop
   if "%v%"=="" goto:EOF
   for /f "tokens=1* delims== " %%i in ("%v%") do (
      set v=%%j
      if /i "%%i"=="CN" ( 
        for /f "tokens=2 delims==," %%k in ("%v%") do set w=%%k
        goto:cont
      ) else (
        goto loop
      )
   )

:cont
   certutil -verifystore My %w% | findstr /l "  Issuer:" > "%TEMP%\%~n0.tmp"
   for /f "usebackq tokens=1* delims=: " %%i in ("%TEMP%\%~n0.tmp") do set rootCA=%%j
   if exist "%TEMP%\%~n0.tmp" del %TEMP%\"%~n0.tmp"

   rem Imports security policy
   rem

   netsh ipsec static importpolicy %vpn_setup_policyFile%
   rem netsh ipsec static set rule id=1 policy=%vpn_setup_policyName% rootca="%rootCA% excludecaname:no"


   rem Configures network connexions
   rem

   copy %vpn_setup_connexions_sourceFile% %vpn_setup_connexions_targetFile%
   for /f "delims=[]" %%i in ('findstr /r /b /e /c:"\[.*\]" %vpn_setup_connexions_targetFile%') do rasphone.exe -f %vpn_setup_connexions_targetFile% -e "%%i"
